/*
 * Decompiled with CFR 0.152.
 */
package pers.mbaeurle.comicgrabber;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import pers.mbaeurle.comicgrabber.AboutWindow;
import pers.mbaeurle.comicgrabber.FetcherThread;

public class ComicGrabber
extends Frame {
    private Button button1;
    private Button buttonFetch;
    private Label label1;
    private Label labelImageUrl;
    private Label labelLinkUrl;
    private Label labelMainUrl;
    private TextArea textAreaLog;
    private TextField textFieldDestFolder;
    private TextField textFieldImageUrl;
    private TextField textFieldLinkUrl;
    private TextField textFieldMainUrl;
    private AboutWindow mAboutWindow;
    private FetcherThread mFetcherThread;

    public ComicGrabber() {
        this.initComponents();
        Preferences pref = Preferences.userNodeForPackage(this.getClass());
        this.textFieldMainUrl.setText(pref.get("MainUrl", "http://www.dilbert.com/comics/dilbert/archive/index.html"));
        this.textFieldLinkUrl.setText(pref.get("LinkUrl", "dilbert-200"));
        this.textFieldImageUrl.setText(pref.get("ImageUrl", "dilbert2"));
        this.textFieldDestFolder.setText(pref.get("DestFolder", "C:\\Temp"));
        this.mAboutWindow = new AboutWindow((Frame)this, false);
        this.mFetcherThread = null;
    }

    private void initComponents() {
        this.labelMainUrl = new Label();
        this.textFieldMainUrl = new TextField();
        this.labelLinkUrl = new Label();
        this.textFieldLinkUrl = new TextField();
        this.buttonFetch = new Button();
        this.textAreaLog = new TextArea();
        this.labelImageUrl = new Label();
        this.textFieldImageUrl = new TextField();
        this.label1 = new Label();
        this.textFieldDestFolder = new TextField();
        this.button1 = new Button();
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.lightGray);
        this.setTitle("Comic Grabber");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ComicGrabber.this.exitForm(evt);
            }
        });
        this.labelMainUrl.setText("Main URL");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.labelMainUrl, gridBagConstraints);
        this.textFieldMainUrl.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.textFieldMainUrl, gridBagConstraints);
        this.labelLinkUrl.setText("Start of link URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.labelLinkUrl, gridBagConstraints);
        this.textFieldLinkUrl.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.textFieldLinkUrl, gridBagConstraints);
        this.buttonFetch.setLabel("Fetch");
        this.buttonFetch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComicGrabber.this.buttonFetchActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.buttonFetch, gridBagConstraints);
        this.textAreaLog.setColumns(50);
        this.textAreaLog.setEditable(false);
        this.textAreaLog.setRows(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.textAreaLog, gridBagConstraints);
        this.labelImageUrl.setText("Start of image URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.labelImageUrl, gridBagConstraints);
        this.textFieldImageUrl.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.textFieldImageUrl, gridBagConstraints);
        this.label1.setText("Destination folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.label1, gridBagConstraints);
        this.textFieldDestFolder.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.textFieldDestFolder, gridBagConstraints);
        this.button1.setActionCommand("buttonAbout");
        this.button1.setLabel("About...");
        this.button1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComicGrabber.this.buttonAboutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.button1, gridBagConstraints);
        this.pack();
    }

    private void buttonAboutActionPerformed(ActionEvent evt) {
        this.mAboutWindow.setVisible(true);
    }

    private void buttonFetchActionPerformed(ActionEvent evt) {
        if (this.mFetcherThread == null) {
            this.mFetcherThread = new FetcherThread(this.textFieldMainUrl.getText(), this.textFieldLinkUrl.getText(), this.textFieldImageUrl.getText(), this.textFieldDestFolder.getText(), this.textAreaLog);
            this.mFetcherThread.start();
        }
    }

    private void exitForm(WindowEvent evt) {
        Preferences pref = Preferences.userNodeForPackage(this.getClass());
        pref.put("MainUrl", this.textFieldMainUrl.getText());
        pref.put("LinkUrl", this.textFieldLinkUrl.getText());
        pref.put("ImageUrl", this.textFieldImageUrl.getText());
        pref.put("DestFolder", this.textFieldDestFolder.getText());
        try {
            pref.flush();
        }
        catch (BackingStoreException bse) {
            this.textAreaLog.append("Error: Unable to store settings!");
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        new ComicGrabber().setVisible(true);
    }
}

