/*
 * Decompiled with CFR 0.152.
 */
package pers.mbaeurle.comicgrabber;

import java.awt.TextArea;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.swing.text.BadLocationException;
import pers.mbaeurle.base.Pair;
import pers.mbaeurle.comicgrabber.ImageFinder;
import pers.mbaeurle.comicgrabber.LinkFinder;

public class FetcherThread
extends Thread {
    private String msMainUrl;
    private String msLinkUrlStart;
    private String msImageUrlStart;
    private String msDestFolder;
    private TextArea mTextAreaLog;

    public FetcherThread(String mainUrl, String linkUrlStart, String imageUrlStart, String destFolder, TextArea textAreaLog) {
        this.msMainUrl = mainUrl;
        this.msLinkUrlStart = linkUrlStart;
        this.msImageUrlStart = imageUrlStart;
        this.msDestFolder = destFolder;
        this.mTextAreaLog = textAreaLog;
    }

    public void run() {
        this.mTextAreaLog.requestFocus();
        this.mTextAreaLog.append("Fetching " + this.msMainUrl + "\n");
        try {
            LinkFinder lFinder = new LinkFinder(this.msMainUrl);
            Set pages = lFinder.fetchLinklist(this.msLinkUrlStart);
            this.mTextAreaLog.append("Found " + pages.size() + " links:\n");
            for (Pair currPair : pages) {
                String sLeafname = (String)currPair.getFirst();
                URL pUrl = (URL)currPair.getSecond();
                this.mTextAreaLog.append(pUrl.toString() + "\n");
                ImageFinder iFinder = new ImageFinder();
                URL iUrl = iFinder.findImageUrl(pUrl, this.msImageUrlStart);
                if (iUrl == null) {
                    this.mTextAreaLog.append("   No matching image found!\n");
                    continue;
                }
                try {
                    boolean res = iFinder.saveImage(iUrl, this.msDestFolder, sLeafname);
                    if (!res) {
                        this.mTextAreaLog.append("   File exists or could not be created!\n");
                        continue;
                    }
                    this.mTextAreaLog.append("   Saved\n");
                }
                catch (IOException ioe) {
                    this.mTextAreaLog.append("  IOException: " + ioe.getMessage() + "\n");
                }
            }
            this.mTextAreaLog.append("Finished!\n");
        }
        catch (MalformedURLException mue) {
            this.mTextAreaLog.append("Malformed URL: " + mue.getMessage() + "\n");
        }
        catch (IOException ioe) {
            this.mTextAreaLog.append("IO Exception!\n");
        }
        catch (BadLocationException ble) {
            this.mTextAreaLog.append("BadLocationException: " + ble.getMessage() + "\n");
        }
        catch (Exception e) {
            this.mTextAreaLog.append(e.getClass().getName() + " occurred: " + e.getMessage() + "\n");
        }
    }
}

