/*
 * Decompiled with CFR 0.152.
 */
package pers.mbaeurle.window;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class TextFileDisplayWindow
extends Dialog {
    private TextArea textArea1;

    public TextFileDisplayWindow(Frame parent, boolean modal, String title, String filename) {
        super(parent, modal);
        this.initComponents();
        this.setTitle(title);
        this.loadTextFromFile(filename);
        this.textArea1.setCaretPosition(0);
    }

    private void initComponents() {
        this.textArea1 = new TextArea();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TextFileDisplayWindow.this.closeDialog(evt);
            }
        });
        this.textArea1.setEditable(false);
        this.add((Component)this.textArea1, "Center");
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void loadTextFromFile(String sFilename) {
        try {
            FileReader fileReader = new FileReader(sFilename);
            BufferedReader buffReader = new BufferedReader(fileReader);
            try {
                String textLine;
                while ((textLine = buffReader.readLine()) != null) {
                    this.textArea1.append(textLine + "\n");
                }
            }
            catch (IOException ioe) {
                this.textArea1.setText("Error while reading " + sFilename);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.textArea1.setText("File '" + sFilename + "' not found.");
        }
    }

    public void adjustSize(int iSizeX, int iSizeY) {
        this.setSize(iSizeX, iSizeY);
    }
}

