/*
 * Decompiled with CFR 0.152.
 */
package de.mbaeurle.trackretter;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.Date;

public class Trackretter {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please specify persistency file and target file as parameters.");
        } else {
            try {
                FileInputStream fileIS = new FileInputStream(args[0]);
                DataInputStream trackIS = new DataInputStream(fileIS);
                FileOutputStream oS = new FileOutputStream(args[1]);
                oS.write("<?xml version='1.0' encoding='UTF-8'?>\r\n".getBytes());
                oS.write("<gpx version='1.1' creator='GPSMID' xmlns='http://www.topografix.com/GPX/1/1'>\r\n".getBytes());
                oS.write("<trk>\r\n<trkseg>\r\n".getBytes());
                while (trackIS.available() >= 19) {
                    StringBuffer sb = new StringBuffer(128);
                    sb.append("<trkpt lat='").append(trackIS.readFloat()).append("' lon='").append(trackIS.readFloat()).append("' >\r\n");
                    sb.append("<ele>").append(trackIS.readShort()).append("</ele>\r\n");
                    sb.append("<time>").append(Trackretter.formatUTC(new Date(trackIS.readLong()))).append("</time>\r\n");
                    sb.append("</trkpt>\r\n");
                    trackIS.readByte();
                    oS.write(sb.toString().getBytes());
                }
                oS.write("</trkseg>\r\n</trk>\r\n".getBytes());
                oS.write("</gpx>\r\n\r\n".getBytes());
                oS.close();
                trackIS.close();
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static final String formatInt2(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return Integer.toString(n);
    }

    private static final String formatUTC(Date time) {
        Calendar c = null;
        if (c == null) {
            c = Calendar.getInstance();
        }
        c.setTime(time);
        return String.valueOf(c.get(1)) + "-" + Trackretter.formatInt2(c.get(2) + 1) + "-" + Trackretter.formatInt2(c.get(5)) + "T" + Trackretter.formatInt2(c.get(11)) + ":" + Trackretter.formatInt2(c.get(12)) + ":" + Trackretter.formatInt2(c.get(13)) + "Z";
    }
}

