/*
 * Decompiled with CFR 0.152.
 */
package de.mbaeurle.wegpunktretter;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Wegpunktretter {
    public static final transient float FAC_RADTODEC = 57.295776f;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please specify persistency file and target file as parameters.");
        } else {
            int num = 0;
            try {
                FileInputStream fileIS = new FileInputStream(args[0]);
                DataInputStream wayIS = new DataInputStream(fileIS);
                FileOutputStream oS = new FileOutputStream(args[1]);
                oS.write("<?xml version='1.0' encoding='UTF-8'?>\r\n".getBytes());
                oS.write("<gpx version='1.1' creator='GPSMID' xmlns='http://www.topografix.com/GPX/1/1'>\r\n".getBytes());
                while (wayIS.available() >= 0) {
                    StringBuffer sb = new StringBuffer(128);
                    int recSize = wayIS.readInt() - 8;
                    int dummy = wayIS.readInt();
                    byte[] bytes = new byte[recSize];
                    int read = wayIS.read(bytes);
                    if (read != recSize) {
                        throw new IOException("Couldn't read record (" + recSize + " Bytes) completely.");
                    }
                    ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                    DataInputStream dis = new DataInputStream(bis);
                    StringBuffer name = new StringBuffer(dis.readUTF());
                    float lat = dis.readFloat();
                    float lon = dis.readFloat();
                    sb.append("<wpt lat='").append(lat * 57.295776f);
                    sb.append("' lon='").append(lon * 57.295776f).append("' >\r\n");
                    sb.append("<name>").append(name).append("</name>\r\n");
                    sb.append("</wpt>\r\n");
                    oS.write(sb.toString().getBytes());
                    ++num;
                }
                oS.write("</gpx>\r\n\r\n".getBytes());
                oS.close();
                fileIS.close();
                System.out.println(String.valueOf(num) + " waypoints read.");
            }
            catch (Exception e) {
                System.out.println(String.valueOf(num) + " waypoints read.");
                e.printStackTrace();
            }
        }
    }
}

